timesteps = 300;  
h = 0.3;
alpha = 0.95;
h1 = h^alpha / gamma(1 + alpha);   

r = 1;
d = 0.2;
s = 3; %sigma 

x = zeros(1, timesteps+1);
y = zeros(1, timesteps+1);
x(1) = 0.5;          
y(1) = 2.5;     

for n = 1:timesteps
    x(n+1) = x(n) + h1 * ( r*x(n) - x(n)*y(n) );
    y(n+1) = y(n) + h1 * ( s - (1/r)*y(n) - d*x(n) + x(n)*y(n) );
end

t = (0:timesteps);

figure;
subplot(2,1,1);
plot(t, x, '.r','markersize',8);
xlabel('n', 'FontSize', 20, 'FontWeight','bold');
ylabel('N(n)', 'FontSize', 20, 'FontWeight','bold');
set(gca, 'LineWidth', 1.5, 'FontSize', 20, 'FontWeight','bold');

subplot(2,1,2);
plot(t, y, '.k','markersize',8);
xlabel('n', 'FontSize', 20, 'FontWeight','bold');
ylabel('I(n)', 'FontSize', 20, 'FontWeight','bold');
set(gca, 'LineWidth', 1.5, 'FontSize', 12, 'FontWeight','bold');